<?php
header("Access-Control-Allow-Origin: *");


require_once "../numletra/conversor.php";
require_once "../phpqrcode/qrlib.php";

require __DIR__ . '/autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;

$datos = json_decode($_POST["datos"], true);
$datacomp= $datos['datacomp'];
$detalle = $datos['detalle'];
$empresa = $datos['empresa'];
$usuario = $datos['usuario'];
$cliente = $datos['cliente'];

$connector = new WindowsPrintConnector($empresa["impresora"]);
$printer = new Printer($connector);
$printer -> initialize();
$printer -> setJustification(1);

if (file_exists('img/logo.png')) {	
	$logo = EscposImage::load('img/logo.png', false);
	$printer->bitImage($logo);
	$printer -> feed(1);
}elseif (file_exists('img/logo.jpg')) {
	$logo = EscposImage::load('img/logo.jpg', false);
	$printer->bitImage($logo);
	$printer -> feed(1);
}

$printer -> setDoubleStrike(true);
$printer -> text($empresa["razon_social"]."\n");
$printer -> text($empresa["ruc"]."\n");
$printer -> setDoubleStrike(false);
$printer -> text($usuario["departamento"].' - '.$usuario["provincia"].' - '.$usuario["distrito"]."\n");
$printer -> text($usuario["direccion"]." - ".$usuario["ciudad"]."\n");
$printer -> text('Cel: '.$usuario["cel_uno"]."    ".$usuario["cel_dos"]."\n");

$printer -> feed(1);
$printer -> setDoubleStrike(true);

$nombre_comprobante=(($datacomp["tipo_comprobante"]=='01')?"FACTURA ELECTRONICA":(($datacomp["tipo_comprobante"]=='03')?"BOLETA VENTA ELECTRONICA":"NOTA CREDITO ELECTRONICA"));
$printer -> text($nombre_comprobante.': '.$datacomp["serie_comprobante"]."-".$datacomp["num_comprobante"]."\n");
$printer -> feed(1);

$printer -> setDoubleStrike(false);
$printer -> setFont(1);
$printer -> setJustification();

$printer -> text("Cliente: ".$datacomp["nombre_razon"]."\n");
$printer -> text("Número Doc: ".$datacomp["num_documento"]."\n");
if ($datacomp["direccion_persona"]!="") {
	$printer -> text('Dirección: '.$datacomp["direccion_persona"]."\n");
}
$printer -> text("Fecha y Hora: ".$datacomp["fecharegistrada"]." ".$datacomp["hora_emision"]."\n");
$printer -> text("Vendedor: ".$usuario["nombre"]."\n");

$printer -> text("----------------------------------------------------------------\n");
$printer -> setDoubleStrike(true);
$printer -> text("Cant.              Descripción                    P.U    Importe\n");
$printer -> setDoubleStrike(false);
$printer -> text("----------------------------------------------------------------\n");

$base_imponible=0;
$impuesto=0;
for ($i=0,$n=count($detalle); $i < $n ; $i++) { 
	$reg = $detalle[$i];

	$importe=$reg['cantidad']*$reg['precio_venta_unitario'];
	$nombre_producto = substr($reg['nombre_articulo'], 0, 40);	

	$cantidad=str_pad((double)$reg['cantidad'],7," ",STR_PAD_BOTH);
	$producto=str_pad($nombre_producto,40," ",STR_PAD_RIGHT);
	$precio_unit=str_pad($reg['precio_venta_unitario'],7," ",STR_PAD_LEFT);
	$importeItem=str_pad(number_format($importe,2),10," ",STR_PAD_LEFT);
	
	$printer -> text($cantidad.$producto.$precio_unit.$importeItem."\n");
	$base_imponible=$base_imponible+$reg['valor_venta_item'];
	$impuesto=$impuesto+$reg['igv_item'];
}

if ($impuesto>0) {
	$gravada=$base_imponible;
	$exonerada="0.00";
	$total=$gravada+$impuesto;
}else{
	$gravada="0.00";
	$exonerada=$base_imponible;
	$total=$exonerada;
}

$printer -> text("----------------------------------------------------------------\n");
$printer -> setFont();
$printer -> setJustification(2);
$printer -> setDoubleStrike(true);

$p_gravada=str_pad(number_format(($gravada),2),12," ",STR_PAD_LEFT);
$printer -> text("Gravada S/".$p_gravada."\n");

$p_exonerada=str_pad(number_format(($exonerada),2),12," ",STR_PAD_LEFT);
$printer -> text("Exonerada S/".$p_exonerada."\n");

$p_impuesto=str_pad(number_format($impuesto,2),12," ",STR_PAD_LEFT);
$printer -> text("IGV (18%) S/".$p_impuesto."\n");

$p_total=str_pad(number_format($total,2),12," ",STR_PAD_LEFT);
$printer -> text("Total S/".$p_total."\n");

$printer -> setJustification(0);
$printer -> setDoubleStrike(false);
$printer -> setFont(1);
$printer -> text("----------------------------------------------------------------\n");
$convertido=convertir($total);
$printer -> text("Son: ".$convertido."\n");

$printer -> text("----------------------------------------------------------------\n");
$printer -> setJustification(Printer::JUSTIFY_CENTER);

$printer -> text("Representación impresa de la ".$nombre_comprobante.",\n");
$printer -> text("consulte la validez en www.sunat.gob.pe\n");


$dataqr = $empresa["ruc"].'|'.$datacomp["tipo_comprobante"].'|'.$datacomp["serie_comprobante"].'|'.$datacomp["num_comprobante"].'|'.number_format($impuesto,2).'|'.number_format($total,2).'|'.$datacomp["fecharegistrada"].'|'.$datacomp["tipo_documento"].'|'.$datacomp["num_documento"].'|';
$file_name="img/qrcode.png";
$precicion="M";
$tamanio= 6;
$contorno=1;
QRcode::png($dataqr, $file_name, $precicion, $tamanio, $contorno);

$rqcode = EscposImage::load($file_name, false);
$printer->bitImage($rqcode);

$printer -> feed(1);
$printer -> text($datacomp['valor_resumen']."\n");
$printer -> setJustification(1);
if($datacomp['tip_op']==1){
	$printer -> text("----------------------------------------------------------------\n");
	$printer -> text("BIENES TRANSFERIDOS EN LA AMAZONIA REGION SELVA PARA SER\n");
	$printer -> text("CONSUMIDO EN LA MISMA\n");
}

$printer -> text("----------------------------------------------------------------\n");
$printer -> text("No se aceptan devoluciones. Cambio de mercaderia max 48\n");
$printer -> text("horas previa presentacion de comprobante\n");
$printer -> text("GRACIAS POR SU COMPRA\n");

$printer -> feed(1);

$printer -> cut();
//$printer -> pulse();
$printer -> close();


