<?php
header("Access-Control-Allow-Origin: *");

require_once "../numletra/conversor.php";
require __DIR__ . '/autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;

$mesa = json_decode($_POST["datos"], true);

$detalle=$mesa['detalle'];
$empresa=$mesa['empresa'];
$sucursal = $mesa['usuario'];

$connector = new WindowsPrintConnector($empresa["impresora"]);
$printer = new Printer($connector);
$printer -> initialize();
$printer -> setJustification(1);

if (file_exists('img/logo.png')) {	
	$logo = EscposImage::load('img/logo.png', false);
	$printer->bitImage($logo);
	$printer -> feed(1);
}elseif (file_exists('img/logo.jpg')) {
	$logo = EscposImage::load('img/logo.jpg', false);
	$printer->bitImage($logo);
	$printer -> feed(1);
}

$printer -> setDoubleStrike(true);
$printer -> text($empresa["razon_social"]."\n");
$printer -> text($empresa["ruc"]."\n");
$printer -> setDoubleStrike(false);
$printer -> text($sucursal["departamento"].' - '.$sucursal["provincia"].' - '.$sucursal["distrito"]."\n");
$printer -> text($sucursal["direccion"]." - ".$sucursal["ciudad"]."\n");
$printer -> text('Cel: '.$sucursal["cel_uno"]."    ".$sucursal["cel_dos"]."\n");

$printer -> feed(1);
$printer -> setDoubleStrike(true);

$printer -> text('CUENTA MESA - '.$mesa["num_mesa"]."\n");
$printer -> feed(1);

$printer -> setDoubleStrike(false);
$printer -> setFont(1);
$printer -> setJustification();
$printer -> text("Fecha y Hora: ".date("d-m-Y")." ".date("H:i:s")."\n");
$printer -> text("Vendedor: ".$sucursal["nombre"]."\n");

$printer -> text("----------------------------------------------------------------\n");
$printer -> setDoubleStrike(true);
$printer -> text("Cant.              Descripción                    P.U    Importe\n");
$printer -> setDoubleStrike(false);
$printer -> text("----------------------------------------------------------------\n");

$total=0;
for ($i=0,$n=count($detalle); $i < $n ; $i++) { 
	$reg = $detalle[$i];

	$importe=$reg['cantidad']*$reg['precio'];

	$nombre_producto = substr($reg['nombre_articulo'], 0, 40);


	$cantidad=str_pad((int)$reg['cantidad'],7," ",STR_PAD_BOTH);
	$producto=str_pad($nombre_producto,40," ",STR_PAD_RIGHT);
	$precio_unit=str_pad($reg['precio'],7," ",STR_PAD_LEFT);
	$importeItem=str_pad(number_format($importe,2),10," ",STR_PAD_LEFT);
	
	$printer -> text($cantidad.$producto.$precio_unit.$importeItem."\n");
	$total=$total+$importe;
}


$printer -> text("----------------------------------------------------------------\n");
$printer -> setFont();
$printer -> setJustification(2);
$printer -> setDoubleStrike(true);

$p_total=str_pad(number_format($total,2),12," ",STR_PAD_LEFT);
$printer -> text("Total S/".$p_total."\n");

$printer -> setJustification(0);
$printer -> setDoubleStrike(false);
$printer -> setFont(1);
$printer -> text("----------------------------------------------------------------\n");
$convertido=convertir($total);
$printer -> text("Son: ".$convertido."\n");

$printer -> text("----------------------------------------------------------------\n");
$printer -> setJustification(1);
$printer -> text("TICKET VALIDO SOLO PARA CONTROL INTERNO DE LA EMPRESA.\n");

$printer -> feed(1);

$printer -> cut();
//$printer -> pulse();
$printer -> close();


